/*
 * Decompiled with CFR 0.152.
 */
package com.cra.common.reg.util;

import com.cra.common.reg.util.CRAConstants;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class CommonValidation {
    public static boolean isInt(String field) {
        if (field.trim() == "" || field.trim().length() == 0) {
            return true;
        }
        int i = 0;
        while (i < field.length()) {
            if (field.charAt(i) < ' ' || field.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        try {
            Long.parseLong(field.trim());
        }
        catch (Exception e) {
            return true;
        }
        return Long.parseLong(field.trim()) < 0L;
    }

    private static boolean isLeap(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    protected static boolean checkValidation(int iYear, int iMonth, int iDay) {
        if (iYear < 1800 || iYear > 2099) {
            return false;
        }
        if (iDay < 1 || iDay > 31 || iMonth < 1 || iMonth > 12) {
            return false;
        }
        if (!CommonValidation.isLeap(iYear) && iMonth == 2 && iDay > 28) {
            return false;
        }
        if (CommonValidation.isLeap(iYear) && iMonth == 2 && iDay > 29) {
            return false;
        }
        return iMonth != 4 && iMonth != 6 && iMonth != 9 && iMonth != 11 || iDay <= 30;
    }

    static boolean isDecimal(String data, int Precision) {
        String field = data.trim();
        boolean error = false;
        if (field.trim() == "" || field.trim().length() == 0) {
            return true;
        }
        int i = 0;
        while (i < data.length()) {
            if (data.charAt(i) < ' ' || data.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        try {
            Double.parseDouble(field);
        }
        catch (Exception e) {
            error = true;
            return error;
        }
        int pointCounter = 0;
        int decimalPosition = 0;
        int length = field.length();
        int j = 0;
        while (j < length) {
            if (!Character.isDigit(field.charAt(j))) {
                if (field.charAt(j) == '.') {
                    ++pointCounter;
                    decimalPosition = j;
                } else {
                    error = true;
                }
            }
            ++j;
        }
        if (field.charAt(0) == '.') {
            return true;
        }
        error = pointCounter == 0 ? true : Precision != length - 1 - decimalPosition;
        if (pointCounter > 1) {
            error = true;
        }
        return error;
    }

    static boolean isFieldNull(String text) {
        if (text.trim() == "" || text.trim().length() == 0) {
            return true;
        }
        return text.length() == 0;
    }

    public static boolean isDate(String date1) {
        boolean errorDate;
        if (date1.trim() == "" || date1.trim().length() == 0 || date1.trim().length() != 8 || date1.length() != 8) {
            return true;
        }
        String dd = date1.substring(0, 2);
        String mm = date1.substring(2, 4);
        String yy = date1.substring(4, 8);
        try {
            errorDate = !CommonValidation.checkValidation(Integer.parseInt(yy), Integer.parseInt(mm), Integer.parseInt(dd));
        }
        catch (Exception e) {
            errorDate = true;
        }
        return errorDate;
    }

    public static boolean isAlphaNum(String data) {
        String field = data.trim();
        if (field.trim() == "" || field.trim().length() == 0) {
            return true;
        }
        int j = 0;
        while (j < field.length()) {
            if (!Character.isLetterOrDigit(field.charAt(j))) {
                return true;
            }
            ++j;
        }
        return false;
    }

    static boolean isValidCharString(String dataString) {
        if (dataString.trim() == "" || dataString.trim().length() == 0) {
            return true;
        }
        int i = 0;
        while (i < dataString.length()) {
            if (dataString.charAt(i) < ' ' || dataString.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isValidCrrNumber(String RRR_No) {
        int intRRR_No2;
        try {
            Long.parseLong(RRR_No.trim());
        }
        catch (Exception e) {
            return true;
        }
        if (Long.parseLong(RRR_No.trim()) == 0L) {
            return true;
        }
        long longRRR_No = Long.parseLong(RRR_No);
        long longRRR_No1 = longRRR_No / 10L;
        int intRRR_No1 = (int)(longRRR_No1 % 7L);
        return intRRR_No1 != (intRRR_No2 = (int)(longRRR_No % 10L));
    }

    public static boolean isDecimalNumber(String data) {
        String Field2 = data.trim();
        if (Field2.trim() == "" || Field2.trim().length() < 4 || Field2.length() < 4) {
            return true;
        }
        int i = 0;
        while (i < data.length()) {
            if (data.charAt(i) < ' ' || data.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        try {
            Double.parseDouble(Field2);
        }
        catch (Exception e) {
            return true;
        }
        if (Field2.charAt(Field2.length() - 3) != '.') {
            return true;
        }
        int localI = 0;
        while (localI < Field2.length()) {
            if ((Field2.charAt(localI) <= '/' || Field2.charAt(localI) >= ':') && Field2.charAt(localI) != '.') {
                return true;
            }
            if (Field2.charAt(localI) == '.' && localI == 0) {
                return true;
            }
            if (Field2.charAt(localI) == '.' && Field2.length() - localI != 3) {
                return true;
            }
            ++localI;
        }
        return false;
    }

    static boolean isValidEmail(String data) {
        String field = data.trim();
        if (CommonValidation.isValidCharString(data)) {
            return true;
        }
        if (field.trim() == "" || field.trim().length() == 0) {
            return true;
        }
        int j = 0;
        while (j < field.length()) {
            if (field.charAt(j) == ' ') {
                return true;
            }
            ++j;
        }
        if (field.charAt(0) == '@' || field.charAt(0) == '.') {
            return true;
        }
        if (field.charAt(field.length() - 1) == '@' || field.charAt(field.length() - 1) == '.') {
            return true;
        }
        int localCount = 0;
        int dotPos = 0;
        int ratePos = 0;
        int j2 = 0;
        while (j2 < field.length()) {
            if (field.charAt(j2) == '@') {
                ratePos = j2;
                if (field.charAt(j2 + 1) == '.') {
                    return true;
                }
                if (++localCount > 1) {
                    return true;
                }
            }
            ++j2;
        }
        if (localCount == 0) {
            return true;
        }
        int x = 0;
        while (x < field.length()) {
            if (field.charAt(x) == '.') {
                dotPos = x;
                if (x + 1 != field.length() && field.charAt(x + 1) == '.') {
                    return true;
                }
            }
            ++x;
        }
        return dotPos < ratePos;
    }

    public static boolean checkTan(String tan) {
        if (tan.trim().length() != 10) {
            return true;
        }
        String subtan = tan.substring(0, 3);
        String midSubtan = tan.substring(4, 9);
        String endSubtan = tan.substring(9, 10);
        boolean rccFlag = false;
        int localR = 0;
        while (localR < CRAConstants.DDO_TAN_RCC.length) {
            if (subtan.equals(CRAConstants.DDO_TAN_RCC[localR])) {
                rccFlag = true;
                break;
            }
            ++localR;
        }
        if (!rccFlag) {
            return true;
        }
        int i = 0;
        while (i < 3) {
            if (subtan.charAt(i) <= '@' || subtan.charAt(i) >= '[') {
                return true;
            }
            ++i;
        }
        if (!Character.isLetterOrDigit(tan.charAt(3))) {
            return true;
        }
        if (Character.isLetter(tan.charAt(3)) && (tan.charAt(3) <= '@' || tan.charAt(3) >= '[')) {
            return true;
        }
        i = 0;
        while (i < 5) {
            if (midSubtan.charAt(i) <= '/' || midSubtan.charAt(i) >= ':') {
                return true;
            }
            ++i;
        }
        int checkBit = Integer.parseInt(midSubtan) % 7;
        if (checkBit == 0 && endSubtan.charAt(0) != 'A') {
            return true;
        }
        if (checkBit == 1 && endSubtan.charAt(0) != 'B') {
            return true;
        }
        if (checkBit == 2 && endSubtan.charAt(0) != 'C') {
            return true;
        }
        if (checkBit == 3 && endSubtan.charAt(0) != 'D') {
            return true;
        }
        if (checkBit == 4 && endSubtan.charAt(0) != 'E') {
            return true;
        }
        if (checkBit == 5 && endSubtan.charAt(0) != 'F') {
            return true;
        }
        return checkBit == 6 && endSubtan.charAt(0) != 'G';
    }

    static boolean isFutureDate(String date) {
        GregorianCalendar cal2;
        if (date.trim().length() != 8 || date.length() != 8) {
            return true;
        }
        Calendar cal1 = Calendar.getInstance();
        return cal1.before(cal2 = new GregorianCalendar(Integer.parseInt(date.substring(4, 8)), Integer.parseInt(date.substring(2, 4)) - 1, Integer.parseInt(date.substring(0, 2))));
    }

    public static boolean checkID(String id) {
        int modOfAin;
        String firstId = id.substring(0, 6);
        String lastId = id.substring(6, 7);
        int ain = Integer.parseInt(firstId);
        int lastDigitOfAin = Integer.parseInt(lastId);
        return lastDigitOfAin != (modOfAin = ain % 7);
    }

    public static boolean checkTabSpaces(String field) {
        int k = 0;
        while (k < field.length()) {
            if (field.charAt(k) == '\t') {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static String trimInnerSpaces(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != ' ') {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isEmpty(String s) {
        try {
            return s.length() == 0;
        }
        catch (NullPointerException n) {
            return true;
        }
    }

    public static boolean checkMaxlength(String s, int maxlength) {
        if (!CommonValidation.isEmpty(s)) {
            return s.length() <= maxlength;
        }
        return true;
    }

    public static boolean isDate_yyyymmdd(String date1) {
        boolean errorDate;
        if (date1.trim() == "" || date1.trim().length() == 0 || date1.trim().length() != 8 || date1.length() != 8) {
            return true;
        }
        String yy = date1.substring(0, 4);
        String mm = date1.substring(4, 6);
        String dd = date1.substring(6, 8);
        try {
            errorDate = !CommonValidation.checkValidation(Integer.parseInt(yy), Integer.parseInt(mm), Integer.parseInt(dd));
        }
        catch (Exception e) {
            errorDate = true;
        }
        return errorDate;
    }

    public static boolean checkFileName(File aDirectory, String filename) {
        boolean returnflag = true;
        String[] filesInDir = aDirectory.list();
        int i = 0;
        while (i < filesInDir.length) {
            if (filename.equals(filesInDir[i])) {
                returnflag = false;
            }
            ++i;
        }
        return returnflag;
    }

    public static boolean checkMandatory(String strFieldValue) {
        String field = strFieldValue.trim();
        return field.trim() != "" && field.trim().length() != 0;
    }

    public static boolean checkMinlength(String s, int minlength) {
        if (!CommonValidation.isEmpty(s)) {
            return s.length() >= minlength;
        }
        return true;
    }

    public static boolean isDate_FormattedInput(String date1) {
        String dd = "";
        String mm = "";
        String yyyy = "";
        String date = "";
        StringTokenizer strTokenizer = new StringTokenizer(date1, "/");
        try {
            while (strTokenizer != null && strTokenizer.hasMoreTokens()) {
                dd = strTokenizer.nextToken().toString();
                mm = strTokenizer.nextToken().toString();
                yyyy = strTokenizer.nextToken().toString();
                date = String.valueOf(dd) + mm + yyyy;
            }
            return !CommonValidation.isDate(date);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void convertCommaStringstoDoubleQuotes(String[] commaStrings) {
        int i = 0;
        while (i < commaStrings.length) {
            if (commaStrings[i] != null && commaStrings[i].contains(",")) {
                commaStrings[i] = String.valueOf('\"') + commaStrings[i] + '\"';
            }
            ++i;
        }
    }
}

